package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;

import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import java.net.UnknownHostException;
import java.util.ArrayList;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityReferBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.User;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ReferActivity extends AppCompatActivity {

    ActivityReferBinding binding;


    String  referCode, appurl;

    private ClipboardManager myClipboard;
    private ClipData myClip;

    Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityReferBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        loadData();

        myClipboard = (ClipboardManager) getSystemService(CLIPBOARD_SERVICE);


        dialog = new Dialog(ReferActivity.this);
        dialog.setContentView(R.layout.loading_dialog);

        if (dialog.getWindow() != null) {
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();


        // Assuming SharedPrefManager is properly implemented to fetch userId
        long userId = SharedPrefManager.getInstance(ReferActivity.this).getUserId();
        MyApi myApi = APIClient.getApiClient(ReferActivity.this).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();
                    referCode = model.getReferCode();
                    binding.refercodeTxt.setText(model.getReferCode());

                } else {
                    Toast.makeText(ReferActivity.this, "Failed to load user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
                if (throwable instanceof UnknownHostException) {
                    Toast.makeText(ReferActivity.this, "Something went wrong", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(ReferActivity.this, "Something went wrong", Toast.LENGTH_SHORT).show();
                    Log.e("API_ERROR", "Failure", throwable);
                }
            }
        });


        binding.copyBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String text = binding.refercodeTxt.getText().toString();
                myClip = ClipData.newPlainText("text", text);
                myClipboard.setPrimaryClip(myClip);
                Toast.makeText(ReferActivity.this, "Refer Code Copied",
                        Toast.LENGTH_SHORT).show();
            }
        });




        String appname = getString(R.string.app_name);


        binding.referBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    Intent shareIntent = new Intent(Intent.ACTION_SEND);
                    shareIntent.setType("text/plain");
                    shareIntent.putExtra(Intent.EXTRA_SUBJECT, "Check out this gaming app!");

                    String shareMessage = "Hi, friend!\n" +
                            appname + " is my favorite gaming app – play and win real cash every day!\n" +
                            "Download now and get ₹10 instantly, plus 20% cashback on your first deposit.\n" +
                            "My referral code: " + referCode + "\n" +
                            "Download and play now: " + appurl;

                    shareIntent.putExtra(Intent.EXTRA_TEXT, shareMessage);
                    startActivity(Intent.createChooser(shareIntent, "Choose an app to share"));
                } catch (Exception e) {
                    Toast.makeText(ReferActivity.this, "Error", Toast.LENGTH_SHORT).show();
                }
            }
        });



        binding.referWhatsapp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    String shareMessage = "Hi, friend!\n" +
                            appname + " is my favorite gaming app – play and win real cash every day!\n" +
                            "Download now and get ₹10 instantly, plus 20% cashback on your first deposit.\n" +
                            "My referral code: " + referCode + "\n" +
                            "Download and play now: " + appurl;

                    Intent whatsappIntent = new Intent(Intent.ACTION_SEND);
                    whatsappIntent.setType("text/plain");
                    whatsappIntent.setPackage("com.whatsapp"); // Only share via WhatsApp
                    whatsappIntent.putExtra(Intent.EXTRA_TEXT, shareMessage);

                    // Check if WhatsApp is installed
                    if (whatsappIntent.resolveActivity(ReferActivity.this.getPackageManager()) != null) {
                        startActivity(whatsappIntent);
                    } else {
                        Toast.makeText(ReferActivity.this, "WhatsApp is not installed.", Toast.LENGTH_SHORT).show();
                    }
                } catch (Exception e) {
                    Toast.makeText(ReferActivity.this, "Error sharing via WhatsApp", Toast.LENGTH_SHORT).show();
                }
            }
        });

    }

    private void loadData() {

        MyApi myApi = APIClient.getApiClient(ReferActivity.this).create(MyApi.class);
        Call<ArrayList<AppModel>> call = myApi.fetchAppSetting();

        call.enqueue(new Callback<ArrayList<AppModel>>() {
            @Override
            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    AppModel model = response.body().get(0); // Fetch first AppModel object
                    appurl = model.getWebsiteUrl();
                } else {
                    Toast.makeText(ReferActivity.this, "No data found", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<AppModel>> call, Throwable throwable) {
                dialog.dismiss();
                Toast.makeText(ReferActivity.this, "Something went wrong" , Toast.LENGTH_SHORT).show();
            }
        });
    }

}